<?php
require "Connection.php";

class Auth {
    private $con;

    public function __construct(){
        $this->con = new Connection();
    }
    private function generateToken($id_user) {
       $token = bin2hex(openssl_random_pseudo_bytes(64)).date("Y_m_d_h_i_s");
       $res = $this->con->select("select * from oceanraceacessos where usuario_id = :id_user", array(":id_user" => $id_user));
       if(count($res) > 0){
           return $this->con->queryReturn("
            INSERT INTO oceanraceacessos (usuario_id,token,status) 
            VALUES (:id_user, :token, 'DESATIVADO')", array(
            ":id_user" =>  $id_user,
            ":token" => $token
        )) ? $token : 0 ;
       } else{
           return $this->con->queryReturn("
            INSERT INTO oceanraceacessos (usuario_id,token,status) 
            VALUES (:id_user, :token, 'ATIVADO')", array(
               ":id_user" =>  $id_user,
               ":token" => $token
           )) ? $token : 0 ;
       }
    }
    public function activateToken($token, $id_user){
        $id_acesso =  $this->requestConnection($token)->select("
            SELECT id_acesso 
            FROM oceanraceacessos
            WHERE usuario_id = :id_user
            AND status = 'DESATIVADO'
            LIMIT 0,1
        ", array(
            ":id_user" => $id_user
        ))[0]['id_acesso'];

        $req = $this->requestConnection($token)->query("
            UPDATE oceanraceacessos
            SET status = 'ATIVADO'
            WHERE id_acesso = :id_acesso
        ",array(
            ":id_acesso" => $id_acesso
        ));

        return $req;
    }
    public function requestAccess($user, $pass) {
        $res = $this->con->select("
            SELECT id_oceanraceparticipantes, oce_email, oce_senha 
            FROM oceanraceparticipantes 
            WHERE oce_email = :email AND  
            oce_senha = :pass
        ", array(
            ":email" => $user,
            ":pass" => $pass
        ));
        return count($res) > 0 ? '
            {
                "access": "granted",
                "token": "'.$this->generateToken($res[0][id_oceanraceparticipantes]).'"
            }
        ' : '
            {
                "access": "denied"
            }
        ';
    }
    public function validateToken($token){
        $res = $this->con->select("
            SELECT * 
            FROM oceanraceacessos
            WHERE date(data_acesso) = CURDATE()
            AND token = :token
        ", array(
            ":token" => $token
        ));

        return count($res) > 0 ? $res : 0;
    }
    public function requestConnection($token) {
        return $this->validateToken($token)? $this->con : 0;
    }
}