import React from 'react'

import '../styles/Question.css';

import {withStyles} from '@material-ui/core/styles';
import {green} from '@material-ui/core/colors';
import Radio from '@material-ui/core/Radio';
import {RadioGroup} from '@material-ui/core';

import {Redirect} from 'react-router-dom'

import logo from '../images/logo.png';

import {_Controller} from '../'
import Loader from "react-loader-spinner";

import {FaArrowRight, FaArrowLeft} from 'react-icons/fa';

import he from "he"

import ReactMomentCountDown from 'react-moment-countdown';
import moment from 'moment';


const MyRadio = withStyles({
    root: {
        color: green[400],
        '&$checked': {
            color: green[600],
        },
    },
    checked: {},
})(props => <Radio color="default" {...props} />);

export default class Question extends React.Component {
    loadQuestion() {
        this.setState({loading: true});
        _Controller.getQuestionInfo(this.props.getToken, this.props.getQuestion)
            .then(res => res.json())
            .then(data => {
                if (this.state.isMounted) {
                    this.setState({
                        data: {
                            id_user: data.id_user,
                            id_questao: data.id_questao,
                            questao_enunciado: data.questao_enunciado,
                            questao_numero: data.questao_numero,
                            alternativas: data.alternativas,
                            questao_categoria: data.questao_categoria,
                            data: data.data
                        },
                        loading: false,
                        respostas: data.respostas
                    })
                }
            })
    }

    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.getQuestion !== this.props.getQuestion) {
            this.loadQuestion()
        }
    }

    componentDidMount() {
        this.state.isMounted = true;
        this.setState({
            loading: false,
        });
        if (this.props.getStatus !== "DESATIVADO") {
            this.loadQuestion();
        }
    }

    constructor(props) {
        super(props);
        this.state = {
            respostas: [],
            loading: false,
        };
        this.handleOptionChange = this.handleOptionChange.bind(this);
        this.submitAnswer = this.submitAnswer.bind(this)
        this.dataTeste = this.dataTeste.bind(this)
        this.onCountdownEnd = this.onCountdownEnd.bind(this)
    }

    handleOptionChange(e) {
        console.log(e.target.value)
        let newresposta = {};
        newresposta.id_questao = this.state.data.id_questao;
        newresposta.id_alternativa = e.target.value;
        this.setState((prevState) => ({
            respostas: prevState.respostas.find(u => u.id_questao === newresposta.id_questao) ? [...prevState.respostas.filter(u => u.id_questao !== newresposta.id_questao), newresposta] : [...prevState.respostas, newresposta]
        }), this.submitAnswer(e.target.value));
    }

    submitAnswer(alternativa) {
        _Controller.submitAnswer(this.props.getToken, this.state.data.id_user, this.state.data.id_questao, alternativa)
            .then(u => u.json())
            .then(u => {
            })
    }
    onCountdownEnd(){
        this.forceUpdate()
    }
    dataTeste(){
        return moment().isBefore(moment(this.state.data.data).add(12, "hours").format())

    }
    render() {
        const renderHTML = (escapedHTML) => React.createElement("p", {dangerouslySetInnerHTML: {__html: escapedHTML}});
        const alfabeto = ["a","b","c","d","e","f","g","h","i","j","k","l","m"];

        return (isActivated => isActivated ? (
            (
                <div className="questionContainer">
                    {this.state.loading === true ? (
                        <div className="loader">
                            <Loader
                                type="Rings"
                                color="#83bc59"
                                height={120}
                                width={120}
                            />
                        </div>
                    ) : undefined}
                    <h1>
                        <button style={this.props.getQuestion < 1 ? {opacity: 0} : {}}
                                onClick={this.props.prevQuestion}><FaArrowLeft/></button>
                        <div>
                            <span style={{color: "#002f62"}}>Ocean Race </span> Quiz
                        </div>
                        <button style={this.props.getQuestion > 20 ? {opacity: 0} : {}}
                                onClick={this.props.nextQuestion}><FaArrowRight/></button>
                    </h1>
                    {this.state.data !== undefined?
                        !this.dataTeste() ? (
                            <div className="final">
                                Questionario encerrado.
                            </div>
                        )  : (
                        <div className="questionBox">
                            <div className="questionBody">
                                <h2>{this.state.data.questao_categoria}
                                    <div>
                                        <b>{this.state.respostas.length}</b> questões respondidas de <b>22</b> <br/> <b> <ReactMomentCountDown onCountdownEnd={this.onCountdownEnd} toDate={moment(this.state.data.data).add(12, "hours")} /> </b> restantes
                                    </div>
                                </h2>
                                {renderHTML(he.decode(this.state.data.questao_enunciado))}
                                <div>
                                    <RadioGroup name={this.state.data.id_questao} onChange={this.handleOptionChange}>
                                        {Object.entries(this.state.data.alternativas).map((i, j, k) => {
                                            return (
                                                <div
                                                    style={j !== k.length - 1 ? {borderBottom: "1px solid rgba(200,200,200)"} : {}}
                                                    key={i[1].id_alternativa} className="radio">
                                                    <label>
                                                        <MyRadio
                                                            style={{
                                                                transform: "scale(1.2)",
                                                                width: 30,
                                                                height: 30
                                                            }}
                                                            value={i[1].id_alternativa}
                                                            checked={this.state.respostas.find(u => u.id_questao === this.state.data.id_questao) !== undefined ? this.state.respostas.find(u => u.id_questao === this.state.data.id_questao).id_alternativa === i[1].id_alternativa ? true : false : false}
                                                        />
                                                        {renderHTML(`<b>${alfabeto[j].toUpperCase()})</b> ${he.decode(i[1].enunciado)}`)}
                                                    </label>
                                                </div>
                                            )
                                        })}
                                    </RadioGroup>
                                </div>
                            </div>
                        </div>
                    ) : undefined}
                </div>
            )
        ) : (
            <Redirect
                to={{
                    pathname: "/autenticacao"
                }}
            />
        ))(this.props.getStatus !== "DESATIVADO" ? true : false)
    }

    componentWillUnmount() {
        this.state.isMounted = false;
    }
}

