//########################################################### PARAMETROS INCICIAIS
let modalName = '#modal_show';
let modalRefreshContent = '#modal_show_load';
let urlBase = '';

/*
* Exite alerta após a ação
* */
function textResponse(str)
{
    return '<div class="container-fluid"><div class="row"><div class="col-xs-12"><div style="margin-top:15px;" class="alert alert-warning" role="alert">'+str+'</div></div></div></div>';
}

function createAlert(status, str)
{
    let strPd, item = $('#refreshAlert');

    if(status === "success"){
        strPd = '<strong>Concluído! </strong>Ação realizada com sucesso!';
        if(str)
            strPd = str;
    }else{
        strPd = '<strong>Ops! </strong>Algo de errado aconteu.';
    }


    let element = '<div class="alert alert-warning alert-dismissible" role="alert">\n' +
        '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>\n' +
        strPd +
        '</div>';

    setTimeout(function () {
        item.html(element);
    },500);


}

function loading(status)
{
    let ele = document.querySelector('.load-screen');

    if(!ele){
        console.log('Elemento não encontrado. Classe que de referencia [class=".load-screen"] ');
    }else{
        if(status){
            document.body.style.overflow = 'hidden';
            ele.classList.add('in');
        }else{
            document.body.style.overflow = '';
            ele.classList.remove('in');
        }
    }


}

//########################################################### LOAD IN CONTENT AND LOAD MODAL
/*
* PARAMETROS PASSADOS NO ELEMENTO DATA
*
* PARA INVOCAR MÈTODO UTILIZE O ELEMENTO: [data-load-modal]
*
* data-page-url-load       - Página onde o load é feito.
* data-page-param          - Parametro passado por GET - ex. www.link.com.br?page.php?param=PARAMETRO_AQUI
* data-page-id-return      - Onde é carregado o load. Como padrão, tudo é carregado no modal, no elemento: [id='modal_show_load'] mas se esse campo é preenchido ele carrega no parametro passado nesse campo
* data-load-progress       - Barra de loade if true
*
* data-page-callback                 - Chama função secundária. Usar o nome da função. ex.: myFunction()
*
* */
$(document).on('click', '[data-load-modal]', function () {
    event.preventDefault();
    let t, pageLoad, paramGet, returnData, dirParam, progress, callBack;
    let loadPd = '#modal_show_load';

    t  = $(this);
    pageLoad = t.data('page-url-load');
    paramGet = t.data('page-param');
    returnData =  t.data('page-id-return');
    progress = t.data('load-progress');

    callBack = t.data('page-callback');

    if(!progress)
        progress = true;

    if(!pageLoad){
        let res = textResponse('<b>Falha ao carregar o conteúdo.</b> Por favor, informe a url da página do LOAD.');
        $(loadPd).html(res);
        $(modalName).modal({"backdrop":"static"});
        return;
    }

    if(!paramGet){
        let res = textResponse('<b>Falha ao carregar o conteúdo.</b> Por favor, informe um parametro.');
        $(loadPd).html(res);
        $(modalName).modal({"backdrop":"static"});
        return;
    }

    dirParam = pageLoad + '?param=' + paramGet;


    if(returnData)
        loadPd = returnData;


    if(progress)
        loading(true);

    $(loadPd).load(urlBase + dirParam, function (e,v) {
        $(modalName).modal({"backdrop": "static"});

        if(progress)
            loading(false);

        if(callBack)
            eval(callBack);

        if (v !== "success")
            $(loadPd).html(textResponse('<b>Falha ao carregar o conteúdo.</b> Diretório não encontrado.'));
    });


});

//########################################################### SUBMIT FORM
/*
* PARAMETROS PASSADOS NO ELEMENTO DATA
*
* PARA INVOCAR MÈTODO UTILIZE O ELEMENTO: [data-submit-form]
*
* data-page-url-load            - Página onde o load é feito.
* data-page-param               - Parametro passado por GET - ex. www.link.com.br?page.php?param=PARAMETRO_AQUI
* data-page-id-return           - Elemento onde é carregado o load de retorno após o processo.
* data-page-param-get           - Parametro do load.
* data-page-close-modal         - Fecha modal após após o processo
*
* data-page-alert-action             - Executa um confirm para executar a ação.
* data-page-callback                 - Chama função secundária. Usar o nome da função. ex.: myFunction()
*
* Exemplo:
* <form data-submit-form data-page-url-load="_acts/act.php" data-page-param="new-test" data-page-param-get="load-test" data-page-id-return="#idTeste">
*
* */
$(document).on('submit', '[data-submit-form]', function (e) {
    e.preventDefault();
    let t, paramPost, returnIdRefer, btn, urlAction, closeModal, paramGet, alertAction, callBack;

    t = $(this);
    btn =  t.find('button[type="submit"]');

    urlAction =  t.data('page-url-load');
    paramPost =  t.data('page-param');

    paramGet = t.data('page-param-get');
    returnIdRefer =  t.data('page-id-return');

    closeModal =  t.data('page-close-modal');
    alertAction =  t.data('page-alert-action');
    callBack = t.data('page-callback');

    if(!closeModal)
        closeModal = false;

    if(!urlAction){
        console.log("Parâmetro ausente - [data-page-url-load='URL_ACTION']");
        return;
    }

    if(!paramPost){
        console.log("Parâmetro ausente - [data-page-param='PARAMETRO_ACTION']");
        return;
    }

    if(returnIdRefer){
        if(!paramGet){
            console.log("Parâmetro ausente - [data-page-url-return='URL_LOAD_RETURN']");
            return;
        }
    }

    if(alertAction){
        c = confirm("Deseja realizar essa ação?");

        if(c){
            ajaxStart();
        }
    }else{
        ajaxStart();
    }

    function ajaxStart()
    {
        $.ajax({
            url: urlBase + urlAction + "?param=" + paramPost,
            data:  t.serialize(),
            type: "POST",
            dataType: "json",
            timeout: 13000,
            beforeSend: function () {
                btn.prop('disabled', true);
            },
            complete: function () {
                btn.prop('disabled', false);
            },
            success: function (data) {
                if(data.textResponse === "success"){
                    if(returnIdRefer){
                        if(closeModal)
                            $(modalName).modal('hide');

                        if(callBack)
                            eval(callBack);

                        $(returnIdRefer).load(urlBase + urlAction + '?param=' + paramGet);
                        createAlert('success');
                    }
                }else{
                    createAlert('error');
                }

            },
            error: function () {}
        })
    }



});

//########################################################### Click item and exec
/*
* PARAMETROS PASSADOS NO ELEMENTO DATA
*
* PARA INVOCAR MÈTODO UTILIZE O ELEMENTO: [data-act-backstage]
*
* data-page-url-load                 - Página onde o load é feito.
* data-page-param                    - Parametro passado por GET - ex. www.link.com.br?page.php?param=PARAMETRO_AQUI
*
* data-page-id-return                - Elemento onde é carregado o load de retorno após o processo.
* data-page-param-get                - Parametro do load.
*
* data-page-alert-action             - Executa um confirm para executar a ação.
*
* data-page-id-refer                 - Passa ID ou outro valor para usar no where do SQL
* data-page-load-progress            - Tela de carregamento. Default = true
* data-page-load-alert-dependencies  - Elemento html que mostra o alerta que não pode apagar.
* data-page-callback                 - Chama função secundária. Usar o nome da função. ex.: myFunction()
*
* exemplo:
* <button data-act-backstage data-page-url-load="_acts/act.php" data-page-param="back-test" data-page-id-refer="1" data-page-param-get="load-test" data-page-id-return="#idTeste" class="btn">teste</button>
*
* */
$(document).on("click", '[data-act-backstage]', function (e) {
    e.preventDefault();
    let t, c, paramPost, returnIdRefer, idItem, urlAction, alertAction, callBack, progress, dependencies, paramGet;

    t = $(this);

    urlAction =  t.data('page-url-load');
    paramPost =  t.data('page-param');

    returnIdRefer =  t.data('page-id-return');
    paramGet = t.data('page-param-get');


    alertAction =  t.data('page-alert-action');
    idItem = t.data('page-id-refer');
    callBack = t.data('page-callback');
    progress = t.data('page-load-progress');
    dependencies = t.data('page-load-alert-dependencies');


    if(!progress)
        progress = true;


    if(!urlAction){
        console.log("Parâmetro ausente - [data-page-url-load='URL_ACTION']");
        return;
    }

    if(!paramPost){
        console.log("Parâmetro ausente - [data-page-param='PARAMETRO_ACTION']");
        return;
    }

    if(!idItem){
        console.log("Parâmetro ausente - [data-page-id-refer='ID']");
        return;
    }

    if(returnIdRefer){
        if(!paramGet){
            console.log("Parâmetro ausente - [data-page-param-get='PARAMETRO_ACTION']");
            return;
        }
    }

    if(alertAction){
        c = confirm("Deseja realizar essa ação?");

        if(c){
            ajaxStart();
        }
    }else{
        ajaxStart();
    }

    function ajaxStart()
    {
        $.ajax({
            url: urlBase + urlAction + "?param=" + paramPost,
            data:  {
                id: idItem
            },
            type: "POST",
            dataType: "json",
            timeout: 13000,
            beforeSend: function () {
                t.prop('disabled', true);

                if(progress)
                    loading(true);
            },
            complete: function () {
                t.prop('disabled', false);

                if(progress)
                    loading(false);
            },
            success: function (data) {
                if(data.textResponse === "success"){
                    if(returnIdRefer){
                        $(returnIdRefer).load(urlBase + urlAction + '?param=' + paramGet);
                        createAlert('success');
                    }

                    if(callBack)
                        eval(callBack);

                }else if(data.textResponse === "dependencies"){
                    if(!dependencies)
                        console.log("Parâmetro ausente - [data-load-alert-dependencies='HTML_ELEMENT']");
                    else {
                        $(dependencies).html('Não é possível remover o registro pois existem outros registros atrelados ao mesmo.').fadeIn();

                        setTimeout(function () {
                            $(dependencies).fadeOut().html('');
                        },5000)
                    }

                }else{

                }

            },
            error: function () {}
        })
    }


});

/* PAGINATION ENGINE */
$(document).on("click", ".paginationEngine a", function (evt) {
    evt.preventDefault();
    let obj = {};

    let url = $(this).attr('href');
    url = url.split('?');
    let $params = url[1].split('&');
    if($params.length > 0){
        for(let a = 0; a < $params.length; a++){
            let explodeParam = $params[a].split('=');
            let key = explodeParam[0];
            obj[key] = explodeParam[1];
        }

        $.ajax({
            type: "GET",
            url: urlBase + '_acts/act.php?param=' + obj['param'] ,
            data: obj,
            dataType: 'html',
            beforeSend: function(){
                loading(true);
            },
            success: function (data) {
                loading(false);
                $('#'+obj['pageRefresh']).html(data);
            }
        })
    }

});

///////////////////////////////////////////////////////////////////////////////////////////////NAO PADRAO





